﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR
{
    public static class AHOBPRLogger
    {
        public static bool LogErrorMessage(string errorType, string errorSource, string errorMessage)
        {
            try
            {
                //ADO
                String stmt = "AHOBPR.sp_InsertErrorLog";
                Dictionary<String, Object> param = new Dictionary<string, object>();
                param.Add("@compoType", "RESTful Service");
                param.Add("@errorType", errorType);
                param.Add("@errorSource", errorSource);
                param.Add("@errorMessage", errorMessage);
                param.Add("@created", "RESTful Service");

                DbUtil.ExecuteSProc(stmt, param);

                return true;
            }
            catch (Exception)
            {
                IntensiveLogging.LogErrorMessage(errorType, errorSource, errorMessage);

                return false;
            }
        }
    }
}
